**********************************************************************************
* Generate regressions in Table 2
*
* Created       on June 19th  2020
* Last modified on January 24th 2022
*
**********************************************************************************



**********************************************************************************
* FOR LOG
cap log close                       
clear                             

log using "./log/reg_tables.log.do", replace text

* FOR LOG
display "$S_TIME  $S_DATE"
**********************************************************************************

**********************************************************************************
set more off
cap prog drop _all
**********************************************************************************

**********************************************************************************
use "../task_LR/output/LRbetas_daily_trade.dta", replace

**********************************************************************************
	* Defining panel
	set more off
	cap egen id = group(ISOPAIR)
	xtset id year

	egen iso_1_t = group(base year)
	egen iso_2_t = group(foreign year)

	* Defining trade variables
	cap drop log_trade log_trade_gdp log_export log_import
	gen log_trade = log(trade_gross)
	gen log_export = log(export)
	gen log_import = log(import)

	gen trade_share = (  trade_gross / gdp_o )*100
	gen key_partner = 0
	replace key_partner = 1 if trade_share > 1

	replace fx_vol = fx_vol*sqrt(252)
	
	*Defining EIA variables 
	sort id year

	gen CUMECU = 0
	replace CUMECU = 1 if EIA == 4 | EIA == 5 | EIA == 6
	gen FTA = 0
	replace FTA = 1 if EIA == 3 
	gen TWPTA = 0
	replace TWPTA = 1 if EIA == 2
	gen OWPTA = 0 
	replace OWPTA = 1 if EIA == 1
.

	cap drop emerging
	gen emerging = 0
	replace emerging = 1 if ///
		base == "BRL" | base == "CLP" | base == "CNY" | base == "COP" | base == "CZK" | base == "EGP" | /// 
		base == "GRD" | base == "HUF" | base == "INR" | base == "IDR" | base == "KRW" | base == "MYR" | ///
		base == "MXN" | base == "PEN" | base == "PHP" | base == "PLN" | base == "QAR" | base == "RUB" | ///
		base == "ZAR" | base == "THB" | base == "TWD" | base == "TRY" | base == "AED" 
**********************************************************************************	

******* EVENT REGRESSIONS: TRADE AFTER TRADE DEAL

****** Defining an event as a change to a FTA or CUMECU agreement
cap drop experiment
gen experiment = FTA + CUMECU
cap drop treat
bys ISOPAIR: egen treat = max(experiment)

cap drop change
sort id year
gen change = 0
bys id: replace change = 1 if experiment > l.experiment 
cap drop change_id
bys id: egen change_id = max(change)

* Identifying year of change:
cap drop event_date
gen aux = year if change == 1
bys id: egen event_date = mean(aux)
drop aux 

* Calculating window
gen window_time = year - event_date

local break = 0

*************************************************** 
* 10 year average
bys id: egen trade_10_event = mean(log_import) if window_time >= `break' & window_time <= 10
bys id: egen aux = mean(log_import) if window_time >= -5 & window_time < `break' 
replace trade_10_event = aux if trade_10_event == .
drop aux

* 5 year average
bys id: egen trade_5_event = mean(log_import) if window_time >= `break' & window_time <= 5
bys id: egen aux = mean(log_import) if window_time >= -5 & window_time < `break'
replace trade_5_event = aux if trade_5_event == .
drop aux
***************************************************

gen post_10 = 0
replace post_10 = 1 if window_time > `break' & window_time <= 10
gen post_5 = 0
replace post_5 = 1 if window_time > `break' & window_time <= 5


gen aux = year if window_time == 0
bys id: egen year_control_10 = mean(aux) if window_time >= -10 & window_time <= 10
bys id: egen year_control_5 = mean(aux) if window_time >= -5 & window_time <= 5
drop aux

preserve
collapse trade_5_event ///
		distw contig comlang_off comcol comleg_pretrans gdp_o ///
		, by(id year_control_5 post_5)			
sort id year

gen post = post_5  

reghdfe trade_5_event ///
				post distw contig comlang_off comcol comleg_pretrans ///
				, absorb(id year_control_5) cluster(id) 					
predict yhat if e(sample)

set more off
eststo clear
eststo: reghdfe trade_5_event ///
				post distw contig comlang_off comcol comleg_pretrans ///
				if yhat != ., absorb(year_control_5) cluster(id) 					
			
eststo: reghdfe trade_5_event ///
				post ///
				, absorb(id year_control_5) cluster(id) 
restore
preserve
collapse trade_10_event ///
		distw contig comlang_off comcol comleg_pretrans gdp_o ///
		 , by(id year_control_10 post_10)
		
gen post = post_10  

reghdfe trade_10_event ///
				post ///
				, absorb(id year_control_10) cluster(id)
predict yhat if e(sample)
		
eststo: reghdfe trade_10_event ///
				post distw contig comlang_off comcol comleg_pretrans ///
				if yhat != ., absorb(year_control_10) cluster(id)

eststo: reghdfe trade_10_event ///
				post ///
				, absorb(id year_control_10) cluster(id) 
				
local output = "./output/Tables/table2.tex"
esttab using `output', compress ///
se(%9.3f) b(%9.3f) scalars(r2 F) star(* 0.10 ** 0.05 *** 0.001) replace ///
mtitle("5Y window" "5Y window" "10Y window" "10Y window") ///
label varlabels(post  "After Trade Deal" ///
				distw "Distance" ///
				contig "Common Border" ///
				comlang_off "Common Language" ///
				comcol "Colonial Link" ///
				comleg_pretrans "Common Legal" ///
				_cons "Constant") nonotes
				

log close
				
